<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Duplicate Categories for Magento 2
*/

declare(strict_types=1);

namespace Amasty\DuplicateCategories\Controller\Adminhtml\DuplicateCategory;

use Amasty\DuplicateCategories\Block\Adminhtml\Category\Duplicate as DuplicateBlock;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\View\Result\PageFactory;

class Duplicate extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var CategoryRepository
     */
    private $categoryRepository;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        CategoryRepository $categoryRepository
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->categoryRepository = $categoryRepository;
        parent::__construct($context);
    }

    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $pageResult = $this->resultPageFactory->create();
        $pageResult->getLayout();
        $pageResult->setActiveMenu('Amasty_DuplicateCategories::amdupcat');
        $pageResult->addBreadcrumb(__('Duplicate Category'), __('Duplicate Category'));
        $pageResult->addContent($pageResult->getLayout()->createBlock(DuplicateBlock::class, 'template'));

        $categoryId = $this->getRequest()->getParam('id');
        /** @var \Magento\Catalog\Model\Category $category */
        $category = $this->categoryRepository->get($categoryId);
        $pageResult->getConfig()->getTitle()->prepend(__('Duplicate Category "' . $category->getName() . '"'));

        return $pageResult;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Catalog::categories');
    }
}
