<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Duplicate Categories for Magento 2
*/

namespace Amasty\DuplicateCategories\Block\Adminhtml\Category\Duplicate;

use Magento\Catalog\Block\Adminhtml\Category\Checkboxes\Tree;

class Categories extends Tree
{
    protected function _prepareLayout()
    {
        $this->setTemplate('Amasty_DuplicateCategories::category/duplicate/categories.phtml');
    }

    public function getIdsString()
    {
        return implode(',', $this->getCategoryIds());
    }

    public function getLoadTreeUrl($expanded = null)
    {
        $params = ['_current' => true, 'id' => null, 'store' => null];
        if (null === $expanded && $this->_backendSession->getIsTreeWasExpanded() || $expanded == true) {
            $params['expand_all'] = true;
        }

        return $this->getUrl('catalog/category/categoriesJson', $params);
    }
}
