<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Duplicate Categories for Magento 2
*/

namespace Amasty\DuplicateCategories\Block\Adminhtml\Category;

use Amasty\DuplicateCategories\Block\Adminhtml\Category\Duplicate\Categories;
use Magento\Backend\Block\Widget;
use Magento\Backend\Block\Widget\Button;

class Duplicate extends Widget
{
    public const SEARCH_REPLACE_COUNT = 10;

    /**
     * Category ID to duplicate
     *
     * @var integer
     */
    protected $categoryId;

    /**
     * Preparing block layout
     *
     * @return \Magento\Backend\Block\Widget
     */
    protected function _prepareLayout()
    {
        $this->getToolbar()->addChild(
            'back_button',
            Button::class,
            [
                'label' => __('Back'),
                'onclick' => 'window.location.href=\'' . $this->getUrl('catalog/category') . '\'',
                'class' => 'back'
            ]
        );

        $this->getToolbar()->addChild(
            'save_button',
            Button::class,
            [
                'label' => __('Duplicate'),
                'class' => 'primary',
                'onclick' => 'confirmCategoryDuplicate();',
            ]
        );
        $this->setTemplate('Amasty_DuplicateCategories::category/duplicate.phtml');

        $this->setChild(
            'parent_category_select',
            $this->getLayout()
                ->createBlock(Categories::class)
        );

        return parent::_prepareLayout();
    }

    public function getParentCategorySelectHtml()
    {
        return $this->getChildHtml('parent_category_select');
    }

    public function getSaveUrl()
    {
        return $this->getUrl('*/*/save', ['id' => $this->getCategoryId()]);
    }
    
    public function getCategoryId()
    {
        if (!$this->categoryId) {
            $this->categoryId = $this->getRequest()->getParam('id');
        }
        return $this->categoryId;
    }

    public function getSearchReplaceCnt()
    {
        return self::SEARCH_REPLACE_COUNT;
    }
}
