<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Related Products (Most Viewed) GraphQl for Magento 2 (System)
 */

use Amasty\Mostviewed\Api\PackRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

$objectManager = Bootstrap::getObjectManager();

/** @var PackRepositoryInterface $packRepository */
$packRepository = $objectManager->get(PackRepositoryInterface::class);

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->get(ProductRepositoryInterface::class);

$simpleId = $productRepository->get('simple_product')->getId();

$packs = $packRepository->getPacksByParentProductsAndStore([$simpleId], 0);
foreach ($packs as $pack) {
    $packRepository->deleteById($pack->getId());
}

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product_rollback.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product_rollback.php');
