<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Related Products (Most Viewed) GraphQl for Magento 2 (System)
 */

use Amasty\Mostviewed\Model\PackProduct;
use Amasty\Mostviewed\Api\PackRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;
use Amasty\Mostviewed\Api\Data\PackExtension;

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product.php');

$objectManager = Bootstrap::getObjectManager();

/** @var PackRepositoryInterface $packRepository */
$packRepository = $objectManager->get(PackRepositoryInterface::class);

/** @var PackProduct $packProduct */
$packProduct = $objectManager->create(PackProduct::class);

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->get(ProductRepositoryInterface::class);

/** @var PackExtension $packExtension */
$packExtension = $objectManager->create(PackExtension::class);

$simpleId = (string)$productRepository->get('simple_product')->getId();
$virtualId = (string)$productRepository->get('virtual_product')->getId();
$productIdsString = $simpleId . ',' . $virtualId;

$newPack = $packRepository->getNew();

$newPack->setName('Amasty Test New Bundle Pack');
$newPack->setStatus(1);
$newPack->setApplyForParent(1);
$newPack->setBlockTitle('Amasty Test Buy together');
$newPack->setCartMessage('Amasty Test Cart Message');
$newPack->setCustomerGroupIds(0);
$newPack->setDiscountAmount('10');
$newPack->setDiscountType(1);
$newPack->setProductIds($productIdsString);
$newPack->setPriority(1);

$newPack->setExtensionAttributes($packExtension->setStores([0]));

$packRepository->save($newPack);

$packId = $newPack->getPackId();

$packProduct->setProductId($simpleId);
$packProduct->setPackId($packId);
$packProduct->setStoreId(0);
$packProduct->save();
