<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Related Products (Most Viewed) GraphQl for Magento 2 (System)
 */

use Amasty\Mostviewed\Model\ResourceModel\RuleIndex;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;
use Amasty\Mostviewed\Api\GroupRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;

$objectManager = Bootstrap::getObjectManager();

/** @var GroupRepositoryInterface $groupRepository */
$groupRepository = $objectManager->get(GroupRepositoryInterface::class);

/** @var RuleIndex $ruleIndex */
$ruleIndex = $objectManager->get(RuleIndex::class);

/** @var SearchCriteriaBuilder $searchCriteria */
$searchCriteria = Bootstrap::getObjectManager()->create(SearchCriteriaBuilder::class);

$searchCriteriaLink = $searchCriteria
    ->addFilter('name', 'Amasty Test Mostviewed Group Name')
    ->addFilter('block_position', 'product_content_top')
    ->create();

$groups = $groupRepository->getList($searchCriteriaLink)->getItems();
foreach ($groups as $group) {
    $ruleIndex->cleanByRuleIds([$group->getGroupId()], RuleIndex::WHERE_SHOW);
    $ruleIndex->cleanByRuleIds([$group->getGroupId()], RuleIndex::WHAT_SHOW);
    $groupRepository->delete($group);
}

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product_rollback.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product_rollback.php');
