<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Related Products (Most Viewed) GraphQl for Magento 2 (System)
 */

use Amasty\Mostviewed\Model\ResourceModel\RuleIndex;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;
use Amasty\Mostviewed\Api\GroupRepositoryInterface;

Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/simple_product.php');
Resolver::getInstance()->requireDataFixture('Magento/GraphQl/Catalog/_files/virtual_product.php');

$objectManager = Bootstrap::getObjectManager();

/** @var GroupRepositoryInterface $groupRepository */
$groupRepository = $objectManager->get(GroupRepositoryInterface::class);

/** @var RuleIndex $ruleIndex */
$ruleIndex = $objectManager->get(RuleIndex::class);

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->get(ProductRepositoryInterface::class);

$condition = [
    'type' => Magento\CatalogRule\Model\Rule\Condition\Combine::class,
    'attribute' => null,
    'operator' => null,
    'value' => '1',
    'is_value_processed' => null,
    'aggregator' => 'all',
    'conditions' => [
        (object)[
            'type' => Magento\CatalogRule\Model\Rule\Condition\Product::class,
            'attribute' => 'sku',
            'operator' => '==',
            'value' => 'simple_product',
            'is_value_processed' => false,
        ]
    ]
];

$whereCondition = [
    'type' => Magento\CatalogRule\Model\Rule\Condition\Combine::class,
    'attribute' => null,
    'operator' => null,
    'value' => '1',
    'is_value_processed' => null,
    'aggregator' => 'all',
    'conditions' => [
        (object)[
            'type' => Magento\CatalogRule\Model\Rule\Condition\Product::class,
            'attribute' => 'sku',
            'operator' => '==',
            'value' => 'virtual_product',
            'is_value_processed' => false,
        ]
    ]
];

$newGroup = $groupRepository->getNew();
$newGroup->setStatus(1);
$newGroup->setStores('0,1');
$newGroup->setPriority(10);
$newGroup->setName('Amasty Test Mostviewed Group Name');
$newGroup->setBlockPosition('product_content_top');
$newGroup->setCustomerGroupIds('0,1');
$newGroup->setBlockTitle('Amasty Test Mostviewed Group Block Title');
$newGroup->setBlockLayout(0);
$newGroup->setSourceType(0);
$newGroup->setSameAs(0);
$newGroup->setReplaceType(0);
$newGroup->setAddToCart(1);
$newGroup->setMaxProducts(8);
$newGroup->setSorting('random');
$newGroup->setShowForOutOfStock(0);
$newGroup->setDisplayWishlistButton(true);
$newGroup->setDisplayCompareButton(true);
$newGroup->setConditionsSerialized(json_encode($condition));
$newGroup->setWhereConditionsSerialized(json_encode($whereCondition));

$groupRepository->save($newGroup);
