<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Related Products (Most Viewed) GraphQl for Magento 2 (System)
 */

namespace Amasty\MostviewedGraphQl\Test\GraphQl;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\GraphQl\Query\Uid;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmMostviewedGroupsTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'amMostviewedGroups';

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * @var Uid
     */
    private $idEncoder;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->productRepository = $objectManager->get(ProductRepositoryInterface::class);
        $this->idEncoder = $objectManager->create(Uid::class);
    }

    /**
     * @group amasty_mostviewed
     *
     * @magentoApiDataFixture Amasty_MostviewedGraphQl::Test/GraphQl/_files/create_mostviewed_group.php
     */
    public function testAmMostviewedGroups(): void
    {
        $position = 'product_content_top';

        $virtualId = $this->productRepository->get('virtual_product')->getId();
        $virtualUid = $this->idEncoder->encode((string)$virtualId);

        $assertArray = [
            'items' => [
                [
                    'add_to_cart' => true,
                    'block_layout' => 0,
                    'block_title' => 'Amasty Test Mostviewed Group Block Title',
                    'display_add_to_compare' => true,
                    'display_add_to_wishlist' => true,
                    'items' => [
                        [
                            'name' => 'Simple Product'
                        ]
                    ],
                    'position' => $position
                ]
            ]
        ];

        $response = $this->graphQlQuery($this->getQuery($virtualUid, $position));

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(string $productUid, string $position): string
    {
        return <<<QUERY
query {
    amMostviewedGroups(uid: "$productUid", position: "$position") {
        items {
            add_to_cart
            block_layout
            block_title
            display_add_to_compare
            display_add_to_wishlist
            items {
                name
            }
            position
        }
    }
}
QUERY;
    }
}
