<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Ui\DataProvider\Rule\Form\Meta\Range;

use Amasty\CustomStockStatusMsi\Model\Source\SourceCodes;
use Magento\Ui\Component\Form\Element\Select;
use Magento\Ui\Component\Form\Field;
use Amasty\Stockstatus\Ui\DataProvider\Rule\Form\Meta\Range\AdditionalColumnsInterface;

class MsiColumns implements AdditionalColumnsInterface
{
    public const FIELD_SOURCE_CODE = 'source_code';

    /**
     * @var SourceCodes
     */
    private $sourceCodes;

    public function __construct(SourceCodes $sourceCodes)
    {
        $this->sourceCodes = $sourceCodes;
    }

    public function execute(): array
    {
        return [
            static::FIELD_SOURCE_CODE => [
                'arguments' => [
                    'data' => [
                        'config' => [
                            'formElement' => Select::NAME,
                            'componentType' => Field::NAME,
                            'component' => 'Amasty_Stockstatus/js/components/source-select',
                            'dataScope' => static::FIELD_SOURCE_CODE,
                            'sortOrder' => 100,
                            'visible' => true,
                            'label' => __('Source Name'),
                            'validation' => [
                                'required-entry' => true
                            ],
                            '__disableTmpl' =>  false,
                            'options' => $this->sourceCodes->toOptionArray(),
                            'listens' => [
                                'value' => 'validateAllRanges'
                            ],
                            'rangesComponentName' => '${ $.parentName.replace(/ranges(.\d+)/, \'ranges\') }',
                        ]
                    ]
                ]
            ]
        ];
    }
}
