<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Ui\DataProvider\Rule\Form\Data\Range;

use Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;
use Amasty\Stockstatus\Api\Data\RangeInterface;
use Amasty\CustomStockStatusMsi\Api\MsiRangeRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Api\SortOrderBuilder;
use Amasty\Stockstatus\Ui\DataProvider\Rule\Form\Data\Range\RangeProviderInterface;

class MsiRangeProvider implements RangeProviderInterface
{
    /**
     * @var MsiRangeRepositoryInterface
     */
    private $msiRangeRepository;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var SortOrderBuilder
     */
    private $sortOrderBuilder;

    public function __construct(
        MsiRangeRepositoryInterface $msiRangeRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        SortOrderBuilder $sortOrderBuilder
    ) {
        $this->msiRangeRepository = $msiRangeRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->sortOrderBuilder = $sortOrderBuilder;
    }

    /**
     * @param int $ruleId
     * @return RangeInterface[]
     */
    public function execute(int $ruleId): array
    {
        $this->searchCriteriaBuilder->addFilter(MsiRangeInterface::RULE_ID, $ruleId);
        $sortBySource = $this->sortOrderBuilder
            ->setField(MsiRangeInterface::SOURCE_CODE)
            ->setAscendingDirection()
            ->create();
        $sortByQtyFrom = $this->sortOrderBuilder
            ->setField(MsiRangeInterface::FROM)
            ->setAscendingDirection()
            ->create();
        $sortByQtyAsc = $this->sortOrderBuilder
            ->setField(MsiRangeInterface::TO)
            ->setAscendingDirection()
            ->create();
        $this->searchCriteriaBuilder->addSortOrder($sortBySource);
        $this->searchCriteriaBuilder->addSortOrder($sortByQtyFrom);
        $this->searchCriteriaBuilder->addSortOrder($sortByQtyAsc);

        return $this->msiRangeRepository->getList($this->searchCriteriaBuilder->create())->getItems();
    }
}
