<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Plugin\InventoryIndexer\Indexer\SourceItem\Strategy;

use Amasty\Stockstatus\Model\Indexer\Rule\ProductProcessor;
use Magento\InventoryIndexer\Indexer\SourceItem\Strategy\Sync;
use Magento\InventoryIndexer\Model\ResourceModel\GetProductIdsBySourceItemIds;

class SyncPlugin
{
    /**
     * @var GetProductIdsBySourceItemIds
     */
    private $productIdsBySourceItemIds;

    /**
     * @var ProductProcessor
     */
    private $productProcessor;

    public function __construct(
        ProductProcessor $productProcessor,
        GetProductIdsBySourceItemIds $productIdsBySourceItemIds
    ) {
        $this->productIdsBySourceItemIds = $productIdsBySourceItemIds;
        $this->productProcessor = $productProcessor;
    }

    /**
     * @param Sync $subject
     * @param void $result
     * @param array $sourceItemIds
     * @return void
     */
    public function afterExecuteList(
        Sync $subject,
        $result,
        array $sourceItemIds
    ): void {
        $productIds = $this->productIdsBySourceItemIds->execute($sourceItemIds);
        if (!empty($productIds)) {
            $this->productProcessor->reindexList($productIds);
        }
    }
}
