<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Plugin\Block\CustomStockStatus;

use Amasty\CustomStockStatusMsi\Model\ConfigProvider;
use Amasty\CustomStockStatusMsi\Model\Source\DisplayMode;
use Amasty\Stockstatus\Block\CustomStockStatus;
use Magento\Store\Model\StoreManagerInterface;

class AddOpenPopupStatus
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    public function afterIsSourcePopupOpenedByStatus(CustomStockStatus $subject, bool $result): bool
    {
        $storeId = (int) $this->storeManager->getStore()->getId();

        $result = $subject->getProduct()->getExtensionAttributes()->getSourcesStatusInformation()
            && $this->configProvider->getDisplayMode($storeId) === DisplayMode::POPUP
            && !$this->configProvider->isBreakdownUseSeparateLink();

        return $result;
    }
}
