<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Observer\Frontend;

use Amasty\CustomStockStatusMsi\Model\Stockstatus\SourceProcessor;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class ProductView implements ObserverInterface
{
    /**
     * @var SourceProcessor
     */
    private $sourceProcessor;

    public function __construct(SourceProcessor $sourceProcessor)
    {
        $this->sourceProcessor = $sourceProcessor;
    }

    public function execute(Observer $observer)
    {
        /** @var ProductInterface $product */
        $product = $observer->getEvent()->getProduct();

        if ($product) {
            $this->sourceProcessor->execute($product);
        }
    }
}
