<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Stockstatus;

use Amasty\CustomStockStatusMsi\Api\Data\SourceStatusInformationInterface;
use Amasty\Stockstatus\Model\Stockstatus\Information;

class SourceInformation extends Information implements SourceStatusInformationInterface
{
    public function setSourceCode(string $sourceCode): void
    {
        $this->setData(static::SOURCE_CODE, $sourceCode);
    }

    public function getSourceCode(): string
    {
        return $this->_get(static::SOURCE_CODE);
    }

    public function setSourceLabel(string $sourceLabel): void
    {
        $this->setData(static::SOURCE_LABEL, $sourceLabel);
    }

    public function getSourceLabel(): string
    {
        return $this->_get(static::SOURCE_LABEL);
    }
}
