<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Stockstatus\Renderer\Status;

use Amasty\CustomStockStatusMsi\Model\ConfigProvider;
use Amasty\CustomStockStatusMsi\Model\Source\DisplayMode;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutInterface;
use Magento\Store\Model\StoreManagerInterface;

class MsiProcessor
{
    public const CLASSIC_TEMPLATE = 'Amasty_CustomStockStatusMsi::sources_breakdown_classic.phtml';

    /**
     * @var LayoutInterface
     */
    private $layout;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        LayoutInterface $layout,
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->layout = $layout;
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    public function render(ProductInterface $product, $inProductList = false, $addWrapper = false): string
    {
        if ($product->getExtensionAttributes()->getSourcesStatusInformation()
            && $sourcesBreakdownBlock = $this->getSourcesBreakdownBlock()
        ) {
            $displayMode = $this->configProvider->getDisplayMode((int) $this->storeManager->getStore()->getId());
            if ($displayMode === DisplayMode::CLASSIC) {
                $sourcesBreakdownBlock->setTemplate(self::CLASSIC_TEMPLATE);
            }

            $sourcesBreakdownBlock->setProduct($product);
            $result = $sourcesBreakdownBlock->toHtml();
        }

        return $result ?? '';
    }

    private function getSourcesBreakdownBlock(): ?Template
    {
        return $this->layout->getBlock('amasty_sources_breakdown') ?: null;
    }
}
