<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;

class DisplayMode implements OptionSourceInterface
{
    public const POPUP = 1;
    public const CLASSIC = 2;

    public function toOptionArray(): array
    {
        return [
            [
                'label' => __('Popup'),
                'value' => self::POPUP
            ],
            [
                'label' => __('Classic'),
                'value' => self::CLASSIC
            ],
        ];
    }
}
