<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\ResourceModel\MsiRange;

use Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;
use Amasty\CustomStockStatusMsi\Model\MsiRange as RangeModel;
use Amasty\CustomStockStatusMsi\Model\ResourceModel\MsiRange as RangeResource;
use Amasty\Stockstatus\Model\ResourceModel\Range\Collection as MainRangeCollection;

class Collection extends MainRangeCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = MsiRangeInterface::ID;

    public function _construct()
    {
        $this->_init(RangeModel::class, RangeResource::class);
    }
}
