<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Range;

use Amasty\Stockstatus\Model\Product\GetQty;
use Magento\Catalog\Api\Data\ProductInterface;

class GetProductQtyAdaptForSourceRange
{
    /**
     * @var GetQty
     */
    private $getQty;

    public function __construct(GetQty $getQty)
    {
        $this->getQty = $getQty;
    }

    public function execute(ProductInterface $product, string $sourceCode): float
    {
        return $this->getQty->execute($product, $sourceCode);
    }
}
