<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model;

use Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;
use Amasty\CustomStockStatusMsi\Model\ResourceModel\MsiRange as MsiRangeResource;
use Amasty\Stockstatus\Model\Range;

class MsiRange extends Range implements MsiRangeInterface
{
    public function _construct()
    {
        $this->_init(MsiRangeResource::class);
    }

    public function getSourceCode(): string
    {
        return (string) $this->_getData(MsiRangeInterface::SOURCE_CODE);
    }

    public function setSourceCode(string $sourceCode): void
    {
        $this->setData(MsiRangeInterface::SOURCE_CODE, $sourceCode);
    }
}
