<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Inventory;

use Amasty\Stockstatus\Model\ResourceModel\Inventory as InventoryResource;
use Magento\Framework\Module\Manager as ModuleManager;

class IsMsiAvailable
{
    /**
     * @var ModuleManager
     */
    private $moduleManager;

    /**
     * @var InventoryResource
     */
    private $inventoryResource;

    public function __construct(
        ModuleManager $moduleManager,
        InventoryResource $inventoryResource
    ) {
        $this->moduleManager = $moduleManager;
        $this->inventoryResource = $inventoryResource;
    }

    public function execute(): bool
    {
        return $this->moduleManager->isEnabled('Magento_Inventory')
            && count($this->inventoryResource->getAllSources()) > 1;
    }
}
