<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Extensions\MsiRange;

use Amasty\CustomStockStatusMsi\Api\MsiRangeRepositoryInterface;
use Amasty\Stockstatus\Model\Rule;
use Magento\Framework\EntityManager\Operation\ExtensionInterface;
use Magento\Framework\Exception\LocalizedException;

class SaveHandler implements ExtensionInterface
{
    /**
     * @var MsiRangeRepositoryInterface
     */
    private $msiRangeRepository;

    public function __construct(MsiRangeRepositoryInterface $msiRangeRepository)
    {
        $this->msiRangeRepository = $msiRangeRepository;
    }

    /**
     * @param Rule|object $entity
     * @param array $arguments
     * @return Rule|bool|object|void
     * @throws LocalizedException
     */
    public function execute($entity, $arguments = [])
    {
        if ($entity->isActivateMsiQtyRanges()) {
            $extensionAttributes = $entity->getExtensionAttributes();
            $ranges = $extensionAttributes->getMsiRanges() ?: [];
            foreach ($ranges as $range) {
                $range->setRuleId((int) $entity->getId());
                $this->msiRangeRepository->save($range);
            }
        } else {
            $this->msiRangeRepository->removeByRuleId((int) $entity->getId());
        }

        return $entity;
    }
}
