<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model\Extensions\MsiRange;

use Amasty\Stockstatus\Api\Data\RangeInterface;
use Amasty\CustomStockStatusMsi\Api\MsiRangeRepositoryInterface;
use Amasty\Stockstatus\Model\Rule;
use Magento\Framework\EntityManager\Operation\ExtensionInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;

class ReadHandler implements ExtensionInterface
{
    /**
     * @var MsiRangeRepositoryInterface
     */
    private $msiRangeRepository;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    public function __construct(
        MsiRangeRepositoryInterface $msiRangeRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        $this->msiRangeRepository = $msiRangeRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @param Rule|object $entity
     * @param array $arguments
     * @return Rule|bool|object|void
     */
    public function execute($entity, $arguments = [])
    {
        if ($entity->isActivateMsiQtyRanges()) {
            $extensionAttributes = $entity->getExtensionAttributes();
            $extensionAttributes->setMsiRanges($this->getRangesByRuleId((int) $entity->getId()));
        }

        return $entity;
    }

    /**
     * @param int $ruleId
     * @return RangeInterface[]
     */
    private function getRangesByRuleId(int $ruleId): array
    {
        $this->searchCriteriaBuilder->addFilter(RangeInterface::RULE_ID, $ruleId);
        return $this->msiRangeRepository->getList($this->searchCriteriaBuilder->create())->getItems();
    }
}
