<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    public const SOURCES_BREAKDOWN_ENABLED = 'msi_configuration/show_breakdown';
    public const SOURCES_BREAKDOWN_TITLE = 'msi_configuration/title';
    public const DISPLAY_MODE = 'msi_configuration/display_mode';
    public const SOURCES_BREAKDOWN_SEPARATE_LINK = 'msi_configuration/use_separate_link';
    public const SOURCES_BREAKDOWN_LABEL = 'msi_configuration/breakdown_label';
    public const REPLACE_DEFAULT_WITH_SOURCE = 'msi_configuration/replacement/source';

    /**
     * @var string
     */
    protected $pathPrefix = 'amstockstatus/';

    public function isReplaceDefaultWithSourceStatus(): bool
    {
        return $this->isSetFlag(self::REPLACE_DEFAULT_WITH_SOURCE);
    }

    public function isBreakdownEnabled(): bool
    {
        return $this->isSetFlag(self::SOURCES_BREAKDOWN_ENABLED);
    }

    public function getBreakdownTitle(): string
    {
        return $this->getValue(self::SOURCES_BREAKDOWN_TITLE);
    }

    public function isBreakdownUseSeparateLink(): bool
    {
        return $this->isSetFlag(self::SOURCES_BREAKDOWN_SEPARATE_LINK);
    }

    public function getBreakdownLabel(): string
    {
        return $this->getValue(self::SOURCES_BREAKDOWN_LABEL);
    }

    public function getDisplayMode(?int $storeId = null): int
    {
        return (int) $this->getValue(self::DISPLAY_MODE, $storeId);
    }
}
