<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Block;

use Amasty\CustomStockStatusMsi\Api\Data\SourceStatusInformationInterface;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class SourcesData extends Template
{
    /**
     * @var string
     */
    protected $_template = 'Amasty_CustomStockStatusMsi::sources_data.phtml';

    /**
     * @var ProductInterface
     */
    private $product;

    public function setProduct(ProductInterface $product): void
    {
        $this->product = $product;
    }

    public function getProduct(): ProductInterface
    {
        return $this->product;
    }

    /**
     * @return SourceStatusInformationInterface[]
     */
    public function getSourcesInformation(): array
    {
        return $this->getProduct()->getExtensionAttributes()->getSourcesStatusInformation();
    }
}
