<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Api;

/**
 * @api
 */
interface MsiRangeRepositoryInterface
{
    /**
     * Save
     *
     * @param \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface $msiRange
     *
     * @return \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface
     */
    public function save(
        \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface $msiRange
    ): \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;

    /**
     * @return \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface
     */
    public function getNew(): \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;

    /**
     * Get by id
     *
     * @param int $id
     *
     * @return \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id): \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface;

    /**
     * Delete
     *
     * @param \Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface $msiRange
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Amasty\CustomStockStatusMsi\Api\Data\MsiRangeInterface $msiRange): bool;

    /**
     * Delete by id
     *
     * @param int $id
     *
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($id): bool;

    /**
     * Lists
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    ): \Magento\Framework\Api\SearchResultsInterface;

    /**
     * Delete Ranges by Rule id
     *
     * @param int $ruleId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function removeByRuleId(int $ruleId): bool;
}
