<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Api\Data;

use Amasty\Stockstatus\Api\Data\StockstatusInformationInterface;

interface SourceStatusInformationInterface extends StockstatusInformationInterface
{
    public const SOURCE_CODE = 'source_code';
    public const SOURCE_LABEL = 'source_label';

    /**
     * @param string $sourceCode
     * @return void
     */
    public function setSourceCode(string $sourceCode): void;

    /**
     * @return string
     */
    public function getSourceCode(): string;

    /**
     * @param string $sourceLabel
     * @return void
     */
    public function setSourceLabel(string $sourceLabel): void;

    /**
     * @return string
     */
    public function getSourceLabel(): string;
}
