<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Stock Status MSI for Magento 2 (System)
 */

namespace Amasty\CustomStockStatusMsi\Api\Data;

use Amasty\Stockstatus\Api\Data\RangeInterface;

interface MsiRangeInterface extends RangeInterface
{
    public const SOURCE_CODE = 'source_code';

    /**
     * @return string
     */
    public function getSourceCode(): string;

    /**
     * @param string $sourceCode
     */
    public function setSourceCode(string $sourceCode): void;
}
