<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Setup\Patch\Data;

use Amasty\CronScheduler\Api\Data\JobsInterface;
use Amasty\CronScheduler\Model\ResourceModel\Jobs;
use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class FillModifiedSchedule implements DataPatchInterface
{
    /**
     * @var ResourceInterface
     */
    private $moduleResource;

    /**
     * @var Jobs
     */
    private $jobsResource;

    public function __construct(
        ResourceInterface $moduleResource,
        Jobs $jobsResource
    ) {
        $this->moduleResource = $moduleResource;
        $this->jobsResource = $jobsResource;
    }

    public function apply()
    {
        $setupDataVersion = $this->moduleResource->getDataVersion('Amasty_CronScheduler');

        if ($setupDataVersion && version_compare($setupDataVersion, '1.0.4', '<')) {
            $this->jobsResource->getConnection()->update(
                $this->jobsResource->getTable(Jobs::TABLE_NAME),
                [JobsInterface::MODIFIED_SCHEDULE => null],
                [JobsInterface::SCHEDULE . ' <> ' . JobsInterface::MODIFIED_SCHEDULE]
            );
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
