<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Plugin\Cron\Model\Config\Data;

use Magento\Cron\Model\Config\Data;

class DeleteDisabledDynamicCronJob
{
    public function afterGetJobs(Data $subject, array $result): array
    {
        foreach ($result as &$groupJobs) {
            foreach ($groupJobs as $key => &$job) {
                /**
                 * If cronjob has dynamic execute time and module disabled, we must unset this job
                 * because we must get all active cronjobs from enabled modules
                 * @see https://experienceleague.adobe.com/docs/commerce-operations/configuration-guide/crons/custom-cron-tutorial.html
                 */
                if (!isset($job['name']) && !isset($job['instance'])) {
                    unset($groupJobs[$key]);
                }
            }
        }

        return $result;
    }
}
