<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Plugin;

use Amasty\CronScheduler\Model\Repository\JobsRepository;
use Amasty\CronScheduler\Model\Jobs;
use Magento\Cron\Model\Config;

class ConfigPlugin
{
    /**
     * @var array
     */
    private $dbJobs = [];

    public function __construct(
        JobsRepository $jobsRepository
    ) {
        $this->initDbJobsData($jobsRepository);
    }

    public function afterGetJobs(Config $subject, array $result): array
    {
        foreach ($result as &$groupJobs) {
            foreach ($groupJobs as &$job) {
                if (isset($job['name']) && array_key_exists($job['name'], $this->dbJobs)) {
                    if ($this->shouldReplaceSchedule($job)) {
                        $job['schedule'] = $this->dbJobs[$job['name']]->getModifiedSchedule();
                        unset($job['config_path']); //modified jobs
                    } elseif ($this->dbJobs[$job['name']]->getStatus() == Jobs::STATUS_DISABLED) {
                        unset($groupJobs[$job['name']]);
                    }
                }
            }
        }

        return $result;
    }

    private function initDbJobsData(JobsRepository $jobsRepository): void
    {
        $jobsFromDb = $jobsRepository->getAll();

        foreach ($jobsFromDb as $savedJob) {
            $this->dbJobs[$savedJob->getJobCode()] = $savedJob;
        }
    }

    private function shouldReplaceSchedule(array $job): bool
    {
        $dbJob = $this->dbJobs[$job['name']];

        return isset($job['schedule'])
            && $dbJob->getModifiedSchedule()
            && $dbJob->getModifiedSchedule() !== $job['schedule']
            && $dbJob->getStatus() != Jobs::STATUS_DISABLED;
    }
}
