<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Model\ResourceModel\Jobs;

use Magento\Framework\App\ResourceConnection;

class DeleteScheduledJobs
{
    public const CRON_SCHEDULE_TABLE_NAME = 'cron_schedule';

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
    }

    public function execute(array $idsForDelete): void
    {
        $connection = $this->resourceConnection->getConnection();
        $tableName = $this->resourceConnection->getTableName(self::CRON_SCHEDULE_TABLE_NAME);

        $connection->delete(
            $tableName,
            ['job_code IN (?)' => $idsForDelete]
        );
    }
}
