<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Model\OptionSource;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Escaper;
use Amasty\CronScheduler\Model\Jobs;

class Status implements OptionSourceInterface
{
    /**
     * @var Escaper
     */
    private $escaper;

    public function __construct(
        Escaper $escaper
    ) {
        $this->escaper = $escaper;
    }

    public function toOptionArray()
    {
        return [
            [
                'value' => Jobs::STATUS_DISABLED, 'label' => '<span class="grid-severity-critical">'
                . $this->escaper->escapeHtml(__("Disabled"))
                . '</span>'
            ],
            [
                'value' => Jobs::STATUS_ENABLED, 'label' => '<span class="grid-severity-notice">'
                . $this->escaper->escapeHtml(__("Enabled"))
                . '</span>'
            ]
        ];
    }
}
