<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Cron Scheduler for Magento 2
 */

namespace Amasty\CronScheduler\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider extends ConfigProviderAbstract
{
    public const PATH_PREFIX = 'amasty_cronscheduler/';

    public const ENABLED = 'email_notification/enabled';

    public const SENDER_EMAIL = 'email_notification/sender_email';

    public const SEND_TO = 'email_notification/send_to';

    public const EMAIL_SUBJECT = 'email_notification/email_subject';

    public const EMAIL_CONTENT = 'email_notification/email_content';

    public const NOTIFICATION_INTERVAL = 'email_notification/notification_interval';

    /**
     * @var string
     */
    protected $pathPrefix = self::PATH_PREFIX;

    /**
     * @param null|string $scopeCode
     *
     * @return bool
     */
    public function getIsEnabled($scopeCode = null)
    {
        return (bool)$this->getValue(self::ENABLED, $scopeCode);
    }

    /**
     * @param null|string $scopeCode
     *
     * @return string
     */
    public function getSenderEmail($scopeCode = null)
    {
        return $this->getValue(self::SENDER_EMAIL, $scopeCode);
    }

    /**
     * @param null|string $scopeCode
     *
     * @return string
     */
    public function getRecievers($scopeCode = null)
    {
        return $this->getValue(self::SEND_TO, $scopeCode);
    }

    /**
     * @param null|string $scopeCode
     *
     * @return string
     */
    public function getEmailSubject($scopeCode = null)
    {
        return $this->getValue(self::EMAIL_SUBJECT, $scopeCode);
    }

    /**
     * @param null|string $scopeCode
     *
     * @return string
     */
    public function getEmailContent($scopeCode = null)
    {
        return $this->getValue(self::EMAIL_CONTENT, $scopeCode);
    }

    /**
     * @param null|string $scopeCode
     *
     * @return string
     */
    public function getNotificationInterval($scopeCode = null)
    {
        return $this->getValue(self::NOTIFICATION_INTERVAL, $scopeCode);
    }
}
