<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Multiple Coupons for Magento 2
*/

namespace Amasty\Coupons\Api;

/**
 * Get Coupons List by cartId/quoteId.
 * @api
 */
interface GetCouponsByCartIdInterface
{
    /**
     * Return list of applied coupons in a specified cart.
     *
     * @param int $cartId The cart ID.
     * @return string[]
     */
    public function get(int $cartId): array;
}
