<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Setup\Patch\Data;

use Amasty\Conf\Setup\Operation\MoveConfigFieldset;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class MoveToPreselect implements DataPatchInterface
{
    /**
     * @var string[]
     */
    private $changedSettings = [
        '"amasty_conf/general/preselect"',
        '"amasty_conf/general/preselect_category"',
    ];

    /**
     * @var MoveConfigFieldset
     */
    private $moveConfigFieldset;

    public function __construct(
        MoveConfigFieldset $moveConfigFieldset
    ) {
        $this->moveConfigFieldset = $moveConfigFieldset;
    }

    /**
     * @return $this
     * @throws LocalizedException
     */
    public function apply()
    {
        $this->moveConfigFieldset->execute(
            MoveConfigFieldset::FIELDSET_GENERAL,
            MoveConfigFieldset::FIELDSET_PRESELECT,
            $this->changedSettings
        );

        return $this;
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
