<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Setup\Patch\Data;

use Amasty\Conf\Helper\Data;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Config;
use Magento\Eav\Setup\EavSetup;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class HidePreselectAttribute implements DataPatchInterface
{
    /**
     * @var EavSetup
     */
    private $eavSetup;

    /**
     * @var Config
     */
    private $eavConfig;

    public function __construct(
        EavSetup $eavSetup,
        Config $eavConfig
    ) {
        $this->eavSetup = $eavSetup;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @return $this
     * @throws LocalizedException
     */
    public function apply()
    {
        $this->eavSetup->updateAttribute(
            Product::ENTITY,
            Data::PRESELECT_ATTRIBUTE,
            'is_visible',
            0
        );
        $this->eavConfig->clear();

        return $this;
    }

    public static function getDependencies()
    {
        return [AddPreselectAttribute::class];
    }

    public function getAliases()
    {
        return [];
    }
}
