<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Setup\Patch\Data;

use Amasty\Conf\Helper\Data;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Config;
use Magento\Catalog\Model\ResourceModel\Eav\Attribute;
use Magento\Eav\Setup\EavSetup;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddPreselectAttribute implements DataPatchInterface
{
    /**
     * @var EavSetup
     */
    private $eavSetup;

    /**
     * @var Config
     */
    private $eavConfig;

    public function __construct(
        EavSetup $eavSetup,
        Config $eavConfig
    ) {
        $this->eavSetup = $eavSetup;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @return $this
     * @throws LocalizedException
     */
    public function apply()
    {
        if ($this->eavSetup->getAttribute(Product::ENTITY, Data::PRESELECT_ATTRIBUTE)) {
            return $this;
        }
        $this->eavSetup->addAttribute(
            Product::ENTITY,
            Data::PRESELECT_ATTRIBUTE,
            [
                'type'                      => 'text',
                'frontend'                  => '',
                'label'                     => 'Simple Preselect',
                'input'                     => 'text',
                'class'                     => '',
                'source'                    => '',
                'global'                    => Attribute::SCOPE_GLOBAL,
                'visible'                   => true,
                'used_in_product_listing'   => true,
                'required'                  => false,
                'user_defined'              => true,
                'default'                   => '',
                'searchable'                => false,
                'filterable'                => false,
                'comparable'                => false,
                'visible_on_front'          => false,
                'unique'                    => false,
                'apply_to'                  => 'configurable',
                'group'                     => 'configurable'
            ]
        );
        $this->eavConfig->clear();

        return $this;
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
