<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Setup\Patch\Data;

use Amasty\Conf\Helper\Data;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Config;
use Magento\Eav\Setup\EavSetup;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddMatrixAttribute implements DataPatchInterface
{
    /**
     * @var EavSetup
     */
    private $eavSetup;

    /**
     * @var Config
     */
    private $eavConfig;

    public function __construct(
        EavSetup $eavSetup,
        Config $eavConfig
    ) {
        $this->eavSetup = $eavSetup;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @return $this
     * @throws LocalizedException
     */
    public function apply()
    {
        if ($this->eavSetup->getAttribute(Product::ENTITY, Data::MATRIX_ATTRIBUTE)) {
            return $this;
        }
        $this->eavSetup->addAttribute(
            Product::ENTITY,
            Data::MATRIX_ATTRIBUTE,
            [
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Display Last Attribute in Rows',
                'input' => 'boolean',
                'used_in_product_listing'   => true,
                'class' => '',
                'source' => \Magento\Eav\Model\Entity\Attribute\Source\Boolean::class,
                'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => 0,
                'apply_to' => 'configurable'
            ]
        );

        $matrixAttribute = $this->eavSetup->getAttributeId(
            Product::ENTITY,
            Data::MATRIX_ATTRIBUTE
        );

        foreach ($this->eavSetup->getAllAttributeSetIds(Product::ENTITY) as $attributeSetId) {
            try {
                $attributeGroupId = $this->eavSetup->getAttributeGroupId(
                    Product::ENTITY,
                    $attributeSetId,
                    'General'
                );
            } catch (\Exception $e) {
                $attributeGroupId = $this->eavSetup->getDefaultAttributeGroupId(
                    Product::ENTITY,
                    $attributeSetId
                );
            }

            /*add attribute to attribute set*/
            $this->eavSetup->addAttributeToSet(
                Product::ENTITY,
                $attributeSetId,
                $attributeGroupId,
                $matrixAttribute
            );
        }
        $this->eavConfig->clear();

        return $this;
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
