<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Setup\Operation;

use Magento\Framework\App\Config\ConfigResource\ConfigInterface;

class MoveConfigFieldset
{
    public const FIELDSET_GENERAL = 'general';
    public const FIELDSET_OUT_OF_STOCK = 'out_of_stock';
    public const FIELDSET_PRESELECT = 'preselect';

    private const CONFIG_ID = 'config_id';
    private const PATH = 'path';

    /**
     * @var ConfigInterface
     */
    private $resourceConfig;

    public function __construct(
        ConfigInterface $resourceConfig
    ) {
        $this->resourceConfig = $resourceConfig;
    }

    public function execute(string $oldFieldset, string $newFieldset, array $fields): void
    {
        $settings = $this->getOldSettings($fields);
        $this->updateSettings($settings, $oldFieldset, $newFieldset);
    }

    private function getOldSettings(array $fields): array
    {
        $connection = $this->resourceConfig->getConnection();
        $select = $connection->select()
            ->from($this->resourceConfig->getMainTable(), [self::CONFIG_ID,self::PATH])
            ->where(sprintf('%s IN (?)', self::PATH), implode(',', $fields));

        return $connection->fetchPairs($select) ?? [];
    }

    private function updateSettings(array $settings, string $oldFieldset, string $newFieldset): void
    {
        $connection = $this->resourceConfig->getConnection();
        foreach ($settings as $key => $value) {
            $value = str_replace($oldFieldset, $newFieldset, $value);
            $connection->update(
                $this->resourceConfig->getMainTable(),
                [self::PATH => $value],
                [sprintf('%s = ?', self::CONFIG_ID) => $key]
            );
        }
    }
}
