<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model\Source;

class ZoomType implements \Magento\Framework\Option\ArrayInterface
{
    public const DISABLED = '';
    public const OUTSIDE = 'window';
    public const INSIDE = 'inner';
    public const LENS = 'lens';
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => self::DISABLED,
                'label' => __('Disabled')
            ],
            [
                'value' => self::OUTSIDE,
                'label' => __('Outside')
            ],
            [
                'value' => self::INSIDE,
                'label' => __('Inside')
            ],
            [
                'value' => self::LENS,
                'label' => __('Lens')
            ]
        ];

        return $options;
    }
}
