<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model\Source;

class TitlePosition implements \Magento\Framework\Option\ArrayInterface
{
    public const FLOAT = 'float';
    public const INSIDE = 'inside';
    public const OUTSIDE = 'outside';
    public const OVER = 'over';

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => self::FLOAT,
                'label' => __('Float')
            ],
            [
                'value' => self::INSIDE,
                'label' => __('Inside')
            ],
            [
                'value' => self::OUTSIDE,
                'label' => __('Outside')
            ],
            [
                'value' => self::OVER,
                'label' => __('Over')
            ]
        ];

        return $options;
    }
}
