<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model\Source;

class Preselect implements \Magento\Framework\Option\ArrayInterface
{
    public const DISABLED = 0;
    public const FIRST_OPTIONS = 1;
    public const CHEAPEST = 2;

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => self::DISABLED,
                'label' => __('No')
            ],
            [
                'value' => self::FIRST_OPTIONS,
                'label' => __('The First Options')
            ],
            [
                'value' => self::CHEAPEST,
                'label' => __('The Cheapest Product')
            ]
        ];

        return $options;
    }
}
