<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model\Source;

class LightboxEffectSlide implements \Magento\Framework\Option\ArrayInterface
{
    public const FADE = 'fade';
    public const SLIDE = 'slide';
    public const TUBE = 'tube';
    public const CIRCULAR = 'circular';
    public const ZOOM_IN_OUT = 'zoom-in-out';
    public const ROTATE = 'rotate';

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => '',
                'label' => __('None')
            ],
            [
                'value' => self::FADE,
                'label' => __('Disappearance')
            ],
            [
                'value' => self::SLIDE,
                'label' => __('Slide')
            ],
            [
                'value' => self::TUBE,
                'label' => __('Tube')
            ],
            [
                'value' => self::CIRCULAR,
                'label' => __('Circular')
            ],
            [
                'value' => self::ZOOM_IN_OUT,
                'label' => __('Zoom-in-out')
            ],
            [
                'value' => self::ROTATE,
                'label' => __('Rotate')
            ]
        ];

        return $options;
    }
}
