<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model\Source;

class ImageChange implements \Magento\Framework\Option\ArrayInterface
{
    public const DISABLED = '';
    public const MOUSE_OVER = 'mouseenter';
    public const ON_CLICK = 'click';
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => self::DISABLED,
                'label' => __('No')
            ],
            [
                'value' => self::MOUSE_OVER,
                'label' => __('On Mouse Hover')
            ],
            [
                'value' => self::ON_CLICK,
                'label' => __('On Click')
            ]
        ];

        return $options;
    }
}
