<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Color Swatches Pro for Magento 2
 */

namespace Amasty\Conf\Model;

use Magento\Framework\Data\CollectionDataSourceInterface;

class ConfigProvider extends \Amasty\Base\Model\ConfigProviderAbstract implements CollectionDataSourceInterface
{
    public const OUT_OF_STOCK = 'general/show_out_of_stock';
    public const OPTION_LABEL = 'matrix/show_option_label';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_conf/';

    public function showOutOfStockConfigurableAttributes(): bool
    {
        return (bool) $this->isSetFlag(self::OUT_OF_STOCK);
    }

    public function showColorOptionLabel(): bool
    {
        return (bool) $this->isSetFlag(self::OPTION_LABEL);
    }
}
