<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package AJAX Shopping Cart for Magento 2
 */

namespace Amasty\Cart\Plugin\Catalog\Ui\DataProvider\Product\Listing\DataProvider;

use Amasty\Cart\Model\ConfigProvider;
use Magento\Catalog\Ui\DataProvider\Product\Listing\DataProvider;
use Magento\Store\Model\StoreManagerInterface;

class AddAjaxData
{
    public const IS_COMPARE_AJAX = 'isCompareAjax';
    public const IS_WISHLIST_AJAX = 'isWishlistAjax';

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    public function afterGetData(DataProvider $subject, array $result): array
    {
        if ($subject->getName() === 'recently_viewed_datasource') {
            $storeId = (int)$this->storeManager->getStore()->getId();
            $result[self::IS_COMPARE_AJAX] = $this->configProvider->isCompareAjax($storeId);
            $result[self::IS_WISHLIST_AJAX] = $this->configProvider->isWishlistAjax($storeId);
        }

        return $result;
    }
}
