<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package AJAX Shopping Cart for Magento 2
 */

namespace Amasty\Cart\Model;

use Amasty\RequestQuote\Model\Cart as RequestQuoteCart;
use Amasty\RequestQuote\Model\Quote\Session;
use Magento\Checkout\Helper\Data;
use Magento\Checkout\Model\Cart;

class SubtotalResolver
{
    /**
     * @var Data
     */
    private $checkoutHelper;

    public function __construct(
        Data $checkoutHelper
    ) {
        $this->checkoutHelper = $checkoutHelper;
    }

    /**
     * @param Cart|Session|RequestQuoteCart $cart
     * @param bool $inclTax
     * @return string
     */
    public function getSubtotalHtml($cart, bool $inclTax = false): string
    {
        $subtotal = 0;
        $totals = $cart->getQuote()->getTotals();

        if (($cart instanceof Session || $cart instanceof RequestQuoteCart) && $inclTax) {
            $subtotal = isset($totals['grand_total']) ? $totals['grand_total']->getValue() : 0;
        } elseif (isset($totals['subtotal'])) {
            if ($inclTax && $totals['subtotal']->getValueInclTax() != 0) {
                $subtotal = $totals['subtotal']->getValueInclTax();
            } elseif (!$inclTax && $totals['subtotal']->getValueExclTax() != 0) {
                $subtotal = $totals['subtotal']->getValueExclTax();
            } else {
                $subtotal = $totals['subtotal']->getValue() ?? 0;
            }
        }

        return $this->checkoutHelper->formatPrice($subtotal);
    }
}
