<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Magento\TestFramework\Helper\Bootstrap;
use Magento\Widget\Model\ResourceModel\Widget\Instance;
use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/posts_rollback.php');

$objectManager = Bootstrap::getObjectManager();

/** @var CollectionFactory $collectionFactory */
$collectionFactory = $objectManager->get(CollectionFactory::class);

/** @var Instance $widgetResourceModel */
$widgetResourceModel = $objectManager->get(Instance::class);

$widget = $collectionFactory->create()
    ->addFieldToFilter('title', 'Test Recent Post Widget Title')
    ->getFirstItem();

if ($widget->getInstanceId()) {
    $widgetResourceModel->delete($widget);
}
