<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Amasty\Blog\Api\TagRepositoryInterface;
use Magento\Framework\View\Design\ThemeInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Widget\Model\ResourceModel\Widget\Instance as ResourceWidget;
use Magento\Widget\Model\Widget\Instance as ModelWidget;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php');

$objectManager = Bootstrap::getObjectManager();

/** @var ResourceWidget $resourceWidget */
$resourceWidget = $objectManager->get(ResourceWidget::class);

/** @var ModelWidget $widget */
$widget = $objectManager->get(ModelWidget::class);

/** @var ThemeInterface $theme */
$theme = $objectManager->create(ThemeInterface::class);

/** @var CategoryRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);

/** @var TagRepositoryInterface $tagRepository */
$tagRepository = $objectManager->create(TagRepositoryInterface::class);

$categoryId = $categoryRepository->getByUrlKey('cat-graph-ql')->getCategoryId();
$tagId = $tagRepository->getByUrlKey('tag-graph-one')->getTagId();
$theme->load('Magento/luma', 'theme_path');

$widget->setData(
    [
        'instance_type' => 'Amasty\\Blog\\Block\\Sidebar\\Wrappers\\RecentpostWrapper',
        'theme_id' => $theme->getId(),
        'title' => 'Test Recent Post Widget Title',
        'store_ids' => [
            0 => '0',
            1 => '1'
        ],
        'widget_parameters' => [
            'instance' => 'Amasty\\Blog\\Block\\Sidebar\\Recentpost',
            'header_text' => 'Header Text Recent Post Test Graph',
            'posts_limit' => '100001',
            'show_images' => '1',
            'display_date' => '1',
            'date_manner' => 'passed',
            'display_short' => '1',
            'short_limit' => '256',
            'amasty_widget_categories' => [
                0 => "$categoryId"
            ],
            'amasty_widget_tags' => [
                0 => "$tagId"
            ]
        ],
        'sort_order' => '0',
        'page_groups' => [],
        'instance_code' => 'amasty_blog_recent_posts',
    ]
);

$resourceWidget->save($widget);
