<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Magento\Framework\View\Design\ThemeInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Widget\Model\ResourceModel\Widget\Instance as ResourceWidget;
use Magento\Widget\Model\Widget\Instance as ModelWidget;

$objectManager = Bootstrap::getObjectManager();

/** @var ResourceWidget $resourceWidget */
$resourceWidget = $objectManager->get(ResourceWidget::class);

/** @var ModelWidget $widget */
$widget = $objectManager->get(ModelWidget::class);

/** @var ThemeInterface $theme */
$theme = $objectManager->create(ThemeInterface::class);
$theme->load('Magento/luma', 'theme_path');

$widget->setData(
    [
        'instance_type' => 'Amasty\\Blog\\Block\\Sidebar\\Wrappers\\FeaturedWrapper',
        'theme_id' => $theme->getId(),
        'title' => 'Test Featured Widget Title',
        'store_ids' => [
            0 => '0',
            1 => '1'
        ],
        'widget_parameters' => [
            'instance' => 'Amasty\\Blog\\Block\\Featured',
            'header_text' => 'Header Text Featured Test Graph',
            'posts_limit' => '',
            'display_date' => '1',
            'date_manner' => 'passed',
            'display_short' => '1',
            'short_limit' => ''
        ],
        'sort_order' => '0',
        'page_groups' => [],
        'instance_code' => 'amasty_blog_featured_posts_widget',
    ]
);

$resourceWidget->save($widget);
